DROP TABLE server;

CREATE TABLE server (
	rec_id          NUMBER          DEFAULT 0 NOT NULL, 
	active		NUMBER		DEFAULT 0 NOT NULL,
	url		VARCHAR2(128)	DEFAULT '' NOT NULL,
	period		NUMBER		DEFAULT 604800 NOT NULL,
	tag		VARCHAR2(16)	DEFAULT '' NOT NULL,
	category	VARCHAR2(16)	DEFAULT '' NOT NULL,
	charset		VARCHAR2(40)	DEFAULT '' NOT NULL,
	lang		VARCHAR2(32)	DEFAULT '' NOT NULL,
	basic_auth	VARCHAR2(64)	DEFAULT '' NOT NULL,
	proxy		VARCHAR2(64)	DEFAULT '' NOT NULL,
	proxy_port	NUMBER		DEFAULT 3128 NOT NULL,
	proxy_auth	VARCHAR2(64)	DEFAULT '' NOT NULL,
	maxhops		NUMBER		    DEFAULT 9999 NOT NULL,
	gindex		NUMBER		    DEFAULT 1 NOT NULL,
	follow		NUMBER		    DEFAULT 1 NOT NULL,
	deletebad	NUMBER		    DEFAULT 0 NOT NULL,
	use_robots	NUMBER		    DEFAULT 1 NOT NULL,
	delete_no_srv	NUMBER		    DEFAULT 1 NOT NULL,
	use_clones	NUMBER		    DEFAULT 1 NOT NULL,
	descweight	NUMBER		    DEFAULT 2 NOT NULL,
	keywordweight	NUMBER		    DEFAULT 2 NOT NULL,
	titleweight	NUMBER		    DEFAULT 2 NOT NULL,
	bodyweight	NUMBER		    DEFAULT 1 NOT NULL,
	urlweight	NUMBER		    DEFAULT 0 NOT NULL,
	urlhostweight	NUMBER		    DEFAULT 0 NOT NULL,
	urlpathweight	NUMBER		    DEFAULT 0 NOT NULL,
	urlfileweight	NUMBER		    DEFAULT 0 NOT NULL,
	max_net_errors	NUMBER		    DEFAULT 16 NOT NULL,
	net_delay_time	NUMBER		    DEFAULT 86400 NOT NULL,
	read_timeout	NUMBER		    DEFAULT 90 NOT NULL
);

CREATE SEQUENCE server_rec_id_seq INCREMENT BY 1 START WITH 1;

ALTER TABLE server ADD CONSTRAINT server_pk PRIMARY KEY (rec_id);

CREATE UNIQUE INDEX srv_url ON server (url); 

INSERT INTO server
	(active,url,period,tag,category,charset,lang,basic_auth,
	proxy,proxy_port,proxy_auth,
	maxhops,gindex,follow,deletebad,use_robots,delete_no_srv,use_clones,
	descweight,keywordweight,titleweight,bodyweight,
	urlweight,urlhostweight,urlpathweight,urlfileweight,
	max_net_errors,net_delay_time,read_timeout)
VALUES
	(1,'http://web.izhcom.ru/',60000,'TT','AA','koi8-r','ru','',
	'',3128,'',
	1000,1,1,0,1,1,1,
	2,2,2,1,
	0,0,0,0,
	100,3600,60);

INSERT INTO server
	(active,url,period,tag,category,charset,lang,basic_auth,
	proxy,proxy_port,proxy_auth,
	maxhops,gindex,follow,deletebad,use_robots,delete_no_srv,use_clones,
	descweight,keywordweight,titleweight,bodyweight,
	urlweight,urlhostweight,urlpathweight,urlfileweight,
	max_net_errors,net_delay_time,read_timeout)
VALUES
	(1,'http://www.udmnet.ru/',60000,'GG','BB','koi8-r','ru','',
	'',3128,'',
	1000,1,1,0,1,1,1,
	2,2,2,1,
	0,0,0,0,
	100,3600,60);
